#include <stdio.h>
#include <string.h>
#include "actvar.h"
#include "xdate.h"
#include "dollar.h"
#include "post.h"
#include "htab.h"
#include "general.h"

actvar   *actvar::first = NULL;
actvar   *actvar::last = NULL;
unsigned  actvar::count = 0;

void actvar::append(void)
{
  next = NULL;
  if (count == 0)
    first = this;
  else
    last->next = this;
  last = this;
  next = NULL;
  number = ++count;
}

actvar::actvar(const char *pname, bool pcredit) : name(pname),
  credit(pcredit)
{
  ;
}

posttrial::posttrial(account *paccount, const xdate &pxdate,
  const char *pjournal, unsigned long pline) : dat(pxdate), line(pline)
{
  next = NULL;
  int i;
  for (i = 0; i < JOURNAL_NAME_SIZE; i++)
    journal[i] = *pjournal != 0 ? *pjournal++ : ' ';
  journal[i] = 0;
  if (paccount->first_post == NULL)
    paccount->first_post = this;
  else
    paccount->last_post->next = this;
  paccount->last_post = this;
}

posttrial::~posttrial()
{
  delete amount;
}

post::post(account *paccount, const xdate &pxdate, const char *pjournal,
  unsigned long pline, const dollar *pamount) : posttrial(paccount, pxdate,
  pjournal, pline)
{
  amount = pamount;
}

trial::trial(account *paccount, const xdate &pxdate, const char *pjournal,
  unsigned long pline) : posttrial(paccount, pxdate, pjournal, pline)
{
  amount = paccount->amount();
}

account::account(const char *pname, bool pcredit) : actvar(pname, pcredit)
{
  first_post = NULL;
}

actvar::~actvar()
{
  delete [] name;
}

void actvar::delete_all(void)
{
  while (first != NULL)
  {
    actvar *next = first->next;
    delete first;
    first = next;
  }
}

account::~account()
{
  while (first_post != NULL)
  {
    posttrial *next = first_post->next;
      delete first_post;
    first_post = next;
  }
}

variable::~variable()
{
  delete amt;
}

variable::variable(const char *pname, bool pcredit) : actvar(pname, pcredit),
  amt(new dollar)
{
  ;
}

dollar *account::amount(void)
{
  dollar *amt = new dollar;
  for (posttrial *p = first_post; p != NULL; p = p->next)
  {
    if (p->is_post())
      *amt += *p->amount;
  }
  return amt;
}

dollar *variable::amount(void)
{
  dollar *a = new dollar;
  *a += *amt;
  return a;
}

bool account::has_postings(void)
{
  for (posttrial *p = first_post; p != NULL; p = p->next)
  {
    if (p->is_post())
      return true;
  }
  return false;
}

void variable::ledger(FILE *f)
{
  ;
}

void account::ledger(FILE *f)
{
  fprintf(f, "%s : %s\n\n", name, credit ? "CREDIT" : "DEBIT ");
  unsigned width = (4 * dollar::number_of_digits) / 3;
  // char *amount_buffer = new char[width+1];
  fprintf(f, "   DATE       JOURNAL");
  putchars(f, ' ', JOURNAL_NAME_SIZE - 5);
  fprintf(f, "LINE");
  putchars(f, ' ', width - 3);
  fprintf(f, "DEBIT");
  putchars(f, ' ', width - 4);
  fprintf(f, "CREDIT\n");
  for (posttrial *p = first_post; p != NULL; p = p->next)
  {
    if (!p->is_post())
    {
      putchars(f, '-', 24 + JOURNAL_NAME_SIZE + 2*width);
      fputc('\n', f);
    }
    // char date_buffer[11];
    // p->dat.edit(date_buffer);
    fprintf(f, "%s ", p->is_post() ? "  " : "TB");
    p->dat.print(f);
    fprintf(f, " %s %5d  ", p->journal, p->line);
    if (p->amount->range() == dollar::CREDIT)
      putchars(f, ' ', width+2);
    p->amount->print(f, dollar::NO_DEBIT_CREDIT, true,
      true);
    fputc('\n', f);
    if (!p->is_post())
    {
      putchars(f, '-', 24 + JOURNAL_NAME_SIZE + 2*width);
      fputc('\n', f);
    }
  }
  fputc('\n', f);
}

alias::alias(const char *pname, actvar *preferent) :
  actvar(pname, false), referent(preferent)
{
  ;
}

alias::~alias()
{
  ;
}

void alias::ledger(FILE *f)
{
  ;
}

dollar *alias::amount(void)
{
  return NULL;
}

bool actvar_match(const actvar *p, const actvar *q, void *pointer)
{
  return match(p->name, q->name);
}

bool actvar_code(const actvar *p, void *pointer)
{
  return htab::codei(p->name);
}

reverse *reverse::first = NULL;
reverse *reverse::last;

reverse::reverse(const post *ppost, const account *pacct) : pst(ppost),
  act(pacct)
{
  if (first == NULL)
    first = this;
  else
    last->next = this;
  last = this;
  next = NULL;
}


