#ifndef H__ACTVAR
#define H__ACTVAR

#include <stdio.h>
#include "xdate.h"
#include "dollar.h"
#include "post.h"

class account;

class posttrial // posting or trial balance
{
  public:
    posttrial *next;
    xdate dat;
    char journal[JOURNAL_NAME_SIZE+1];
    unsigned long line;
    const dollar *amount;
    virtual bool is_post(void) = 0;
    virtual ~posttrial();
  protected:
    posttrial(account *, const xdate &, const char *, unsigned long);
};

class post : public posttrial
{
  public:
    post(account *, const xdate &, const char *, unsigned long,
      const dollar *);
    bool is_post(void) {return true;}
};

class trial : public posttrial
{
  public:
    trial(account *, const xdate &, const char *, unsigned long);
    bool is_post(void) {return false;}
};

class actvar
{
  public:
    static actvar *first;
    static actvar *last;
    static unsigned count;
    static void delete_all(void);
    actvar *next;
    unsigned number;
    const char *name;
    bool credit;
    enum typetype {ACCOUNT, VARIABLE, ALIAS};
    virtual typetype type(void) = 0;
    virtual bool has_postings(void) = 0;
    virtual dollar *amount(void) = 0;
    virtual void ledger(FILE *) = 0;
    actvar(const char *, bool);
    virtual ~actvar();
    void append(void);
};

class account : public actvar
{
  public:
    posttrial *first_post;
    posttrial *last_post;
    account(const char *, bool);
    typetype type(void) {return ACCOUNT;}
    bool has_postings(void);
    dollar *amount(void);
    void ledger(FILE *);
    ~account();
};

class variable : public actvar
{
  public:
    dollar *amt;
    variable(const char *, bool);
    dollar *amount(void);
    typetype type(void) {return VARIABLE;}
    bool has_postings(void) {return false;}
    void ledger(FILE *);
    ~variable();
};

bool actvar_match(const actvar *, const actvar *, void *);
bool actvar_code(const actvar *, void *);

class alias : public actvar
{
  public:
    typetype type(void) {return ALIAS;}
    bool has_postings(void) {return false;}
    dollar *amount(void);
    void ledger(FILE *);
    actvar *referent;
    alias(const char *, actvar *);
    ~alias();
};

class reverse
{
  public:
    static reverse *first, *last;
    reverse *next;
    const post *pst;
    const account *act;
    reverse(const post *, const account *);
};

#endif
