#include <stdio.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "dollar.h"

extern void numeric_overflow(void);

unsigned dollar::number_of_digits = 0;
char dollar::separator = ',';
char dollar::decimal = '.';

dollar::dollar(void)
{
  if (number_of_digits == 0)
    number_of_digits = 18;
  digits = new unsigned char[number_of_digits];
  credit = false;
  memset(digits, 0, number_of_digits);
}

dollar::~dollar()
{
  delete [] digits;
}

unsigned dollar::nonzero_digits(void) const
{
  unsigned i = 0;
  while (i < number_of_digits && digits[i] == 0)
    i++;
  return number_of_digits-i;
}

void dollar::operator += (const dollar &d)
{
  if (credit == d.credit)
  {
    int carry = 0;
    for (int i = number_of_digits-1; i >= 0; i--)
    {
      digits[i] += d.digits[i] + carry;
      if (digits[i] >= 10)
      {
        digits[i] -= 10;
        carry = 1;
      }
      else
        carry = 0;
    }
    if (carry != 0)
      numeric_overflow();
  }
  else
  {
    unsigned char *larger;
    unsigned char *smaller;
    if (memcmp(digits, d.digits, number_of_digits) >= 0)
    {
      larger = digits;
      smaller = d.digits;
    }
    else
    {
      larger = d.digits;
      smaller = digits;
      credit = d.credit;
    }
    int borrow = 0;
    for (int i = number_of_digits-1; i >= 0; i--)
    {
      unsigned char n = smaller[i] + borrow;
      if (larger[i] >= n)
      {
        digits[i] = larger[i] - n;
        borrow = 0;
      }
      else
      {
        digits[i] = larger[i] + 10 - n;
        borrow = 1;
      }
    }
  }
}

void dollar::negate(void)
{
  credit = !credit;
}

void dollar::operator = (const dollar &d)
{
  memcpy(digits, d.digits, number_of_digits+1);
}

enum dollar::dcz dollar::range(void) const
{
  return nonzero_digits() == 0 ? ZERO : credit ? CREDIT : DEBIT;
}

void dollar::print(FILE *fp, enum edit_type type, bool cents,
  bool separators) const
{
  enum spno_type {SPACES, PARENTHESES, NOTHING};
  static enum spno_type SPNOTABLE[] =
  {
     // type             range()    spno
     /* DEBIT_EXPECTED   DEBIT  */  SPACES,
     /* DEBIT_EXPECTED   CREDIT */  PARENTHESES,
     /* DEBIT_EXPECTED   ZERO   */  SPACES,
     /* CREDIT_EXPECTED  DEBIT  */  PARENTHESES,
     /* CREDIT_EXPECTED  CREDIT */  SPACES,
     /* CREDIT_EXPECTED  ZERO   */  SPACES,
     /* NO_DEBIT_CREDIT  DEBIT  */  NOTHING,
     /* NO_DEBIT_CREDIT  CREDIT */  NOTHING,
     /* NO_DEBIT_CREDIT  ZERO   */  NOTHING
  };
  enum spno_type spno = SPNOTABLE[type + range()];
  switch (spno)
  {
    case SPACES:
        fputc(' ', fp);
        break;
    case PARENTHESES:
        fputc('(', fp);
        break;
  }
  bool zero_suppression = true;
  unsigned i;
  unsigned separator_position = (number_of_digits+1) % 3;
  for (i = 0; i < number_of_digits-2; i++)
  {
    if (separators && i != 0 && i % 3 == separator_position)
      fputc(zero_suppression ? ' ' : separator, fp);
    zero_suppression = zero_suppression && digits[i] == 0 &&
      i < number_of_digits-3;
    fputc(zero_suppression ? ' ' : digits[i] + '0', fp);
  }
  if (cents)
  {
    fputc('.', fp);
    fputc(digits[i++] + '0', fp);
    fputc(digits[i] + '0', fp);
  }
  switch (spno)
  {
    case SPACES:
        fputc(' ', fp);
        break;
    case PARENTHESES:
        fputc(')', fp);
        break;
  }
}

bool dollar::scan(const char *&s)
{
  while (*s == ' ' || *s == '\t')
    s++;
  if (!isdigit(*s))
    return false;
  unsigned i = 0;
  int separator_location = -1;
  while (true)
  {
    if (isdigit(*s))
    {
      if (i == number_of_digits)
        return false;
      digits[i++] = *s++ - '0';
    }
    else if (*s == separator)
    {
      if (separator_location >= 0 && (unsigned) separator_location+3 != i)
        return false;
      separator_location = i;
      s++;
    }
    else if (*s == decimal)
    {
      if (separator_location >= 0 && (unsigned) separator_location+3 != i)
        return false;
      if (i > number_of_digits-2)
        return false;
      s++;
      if (isdigit(*s))
      {
        digits[i++] = *s++ - '0';
        if (!isdigit(*s))
          return false;
        digits[i++] = *s++ - '0';
        if (isdigit(*s) || *s == '.')
          return false;
        break;
      }
    }
    else
    {
      if (separator_location >= 0 && (unsigned) separator_location+3 != i)
        return false;
      if (i > number_of_digits-2)
        return false;
      digits[i++] = 0;
      digits[i++] = 0;
      break;
    }
  }
  credit = false;
  int j = number_of_digits;
  while (i > 0)
    digits[--j] = digits[--i];
  while (j > 0)
    digits[--j] = 0;
  return true;
}

