#include <string.h>
#include "gstring.h"

gstring::gstring(void)
{
  current = &base;
  length = 0;
}

gstring::~gstring()
{
  buffer *b = base.next;
  while (length > GSTRING_BLOCK_SIZE)
  {
    buffer *next = b->next;
    delete b;
    length -= GSTRING_BLOCK_SIZE;
    b = next;
  }
}

gstring & gstring::operator << (char c)
{
  if (length < GSTRING_BLOCK_SIZE)
    base.data[length] = c;
  else
  {
    unsigned n = length % GSTRING_BLOCK_SIZE;
    if (n == 0)
    {
      current->next = new buffer;
      current = current->next;
    }
    current->data[n] = c;
  }
  length++;
  return *this;
}

gstring & gstring::operator << (const char *s)
{
  while (*s != 0) *this << *s++;
  return *this;
}

void gstring::append(const char *s, unsigned slen)
{
  while (slen != 0)
  {
    *this << *s++;
    slen--;
  }
}

char *gstring::string(void)
{
  char *s = new char[length+1];
  buffer *b = &base;
  unsigned slen = 0;
  while (slen < length)
  {
    unsigned n = length - slen;
    if (n > GSTRING_BLOCK_SIZE)
      n = GSTRING_BLOCK_SIZE;
    memcpy(s + slen, b->data, n);
    slen += n;
    b = b->next;
  }
  s[length] = 0;
  return s;
}

