#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <commdlg.h>
#include "guipost.h"

const int MAX_SPEC_SIZE = 256;

static char configspecs[MAX_SPEC_SIZE+1];
static char specs[MAX_SPEC_SIZE+1];
static char addspecs[MAX_SPEC_SIZE+1];
static FILE *config;
static int configchar;

void diag(char *f, ...)  // diagnostic
{
  static char s[256*4];
  wvsprintf(s, f, &f + 1);
  MessageBox(NULL, s, "Diagnostic Message", MB_OK);
}

/*---------------------------------------------------------------------------

A file specification that cannot be shown in its entirety must be
abbreviated. Truncation at the right end is not the best method, because
it eliminates the most informative part of the specification. It is much
better to eliminate the middle, if possible.

The following function call abbreviates a file specification:

     abbreviate_filespecs(destination, source, length);

     char *destination;   buffer to hold abbreviated specification

     const char *source;  specification to be abbreviated

     int length;          maximum length of abbreviated specification,
                          excluding the terminating nul

To prevent buffer overflow, the destination buffer must be able to hold
at least length+1 bytes.

The function may fail if the length argument is less than 9.

The source and destination buffers must not overlap.

If the source specification is no longer than the specified maximum
length, it is copied into the destination buffer unchanged.

The drive specification, if any, is preserved in the abbreviation.

The sequence "./" or "../" at the beginning of the path is preserved.

If possible, the omitted portion of the file specification consists of a
whole number of subdirectories.

The omitted portion is replaced by three consecutive periods (...).

---------------------------------------------------------------------------*/

inline int separator(int c)
{
  return c == '\\' || c == '/';
}

static void abbreviate_filespecs(char *destination, const char *source,
  unsigned length)
{
  unsigned excess;
  unsigned source_length = strlen(source);
  if (source_length <= length)
  {
    strcpy(destination, source);
  } else
  {
    unsigned excess = source_length - length + 3;
    /* always include drive or LAN specification, if any */
    if (source[1] ==':')
    {
      *destination++ = *source++;
      *destination++ = *source++;
    } else
    if (separator(source[0]) && separator(source[1])) {
      *destination++ = *source++;
      *destination++ = *source++;
    }
    /* include root directory, if present */
    if (separator(*source))
        *destination++ = *source++;
    /* include current directory, if present */
    else if (source[0] == '.' && separator(source[1]))
    {
      *destination++ = *source++;
      *destination++ = *source++;
    }
    /* include parent directory, if present */
    else if (source[0] == '.' && source[1] == '.' &&  separator(source[2]))
    {
      *destination++ = *source++;
      *destination++ = *source++;
      *destination++ = *source++;
    }
    *destination++ = '.';
    *destination++ = '.';
    *destination++ = '.';
    source += excess;
    /* try to make the break at a separator */
    {
      int i;
      for (i = 0; i < 6; i++)
      {
        if (separator(source[i]))
        {
          source += i;
          break;
        }
      }
    }
    strcpy(destination, source);
  }
}


LRESULT CALLBACK WndProc(HWND window, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
    case WM_CREATE:
      return 0;
    case WM_COMMAND:
      switch((WORD) wParam)
      {
        case CLOSEID:
          DestroyWindow(window);
          return 0;
        case ADDID:
        {
          OPENFILENAME f;
          memset(&f, 0, sizeof(f));
          f.lStructSize = sizeof(f)-12; // bug fix required because
                                        // _WIN32_WINNT is 0x500
          f.hwndOwner = window;
          // f.hInstance = 0;
          f.lpstrFilter = "All files (*.*)\0*.*\0";
          // f.lpstrCustomFilter = NULL;
          // f.nMaxCustFilter = 0;
          f.nFilterIndex = 1;
          f.lpstrFile = addspecs;
          f.nMaxFile = sizeof(addspecs);
          // f.lpstrFileTitle = NULL;
          // f.nMaxFileTitle = 0;
          // f.lpstrInitialDir = NULL;
          f.lpstrTitle = "Journal File";
          f.Flags =  OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
          // f.nFileOffset = 0;
          // f.nFileExtension = 0;
          f.lpstrDefExt = "";
          // f.lCustData = 0;
          // f.lpfnHook = NULL;
          // f.lpTemplateName = NULL;
          if (GetOpenFileName(&f))
          {
            LONG i = SendDlgItemMessage(window, LISTID, LB_FINDSTRINGEXACT,
              -1, (LPARAM) addspecs);
            if (i < 0)
            {
              i = SendDlgItemMessage(window, LISTID, LB_ADDSTRING, 0,
                (LPARAM) addspecs);
            }
            SendDlgItemMessage(window, LISTID, LB_SETCURSEL, i, 0);
            EnableWindow(GetDlgItem(window, POSTID), TRUE);
            EnableWindow(GetDlgItem(window, REMOVEID), TRUE);
            SetFocus(GetDlgItem(window, POSTID));
          }
          InvalidateRect(window, NULL, TRUE);
          return 0;
        }
        case REMOVEID:
        {
          int i = SendDlgItemMessage(window, LISTID, LB_GETCURSEL, 0, 0);
          if (i >= 0)
          {
            SendDlgItemMessage(window, LISTID, LB_DELETESTRING, i, 0);
            if (SendDlgItemMessage(window, LISTID, LB_SETCURSEL, i, 0) ==
              LB_ERR)
            {
              EnableWindow(GetDlgItem(window, POSTID), FALSE);
              EnableWindow(GetDlgItem(window, REMOVEID), FALSE);
            }
          }
          return 0;
        }
        case POSTID:
        {
          int n = SendDlgItemMessage(window, LISTID, LB_GETCURSEL, 0, 0);
          if (n >= 0)
          {
            SetDlgItemText(window, ERRCAPID, "");
            SetDlgItemText(window, ERRORID, "");
            SendDlgItemMessage(window, LISTID, LB_GETTEXT, n, (LPARAM) specs);
            static char tempdir[MAX_SPEC_SIZE+1];
            static char tempspecs[MAX_SPEC_SIZE+1];
            GetTempPath(sizeof(tempdir), tempdir);
            GetTempFileName(tempdir, "pvp", 0, tempspecs);
            static char commandline[10+MAX_SPEC_SIZE+1+MAX_SPEC_SIZE+1];
            strcpy(commandline, "POST ");
            strcat(commandline, specs);
            strcat(commandline, " ");
            strcat(commandline, tempspecs);
            static char currentdir[MAX_SPEC_SIZE+1];
            strcpy(currentdir, specs);
            {
              int j = strlen(currentdir)-1;
              while (j > 0 && currentdir[j] != '\\')
                j--;
              currentdir[j == 2 ? 3 : j] = 0;
            }

            STARTUPINFO si;
            PROCESS_INFORMATION pi;
            ZeroMemory( &si, sizeof(si) );
            si.cb = sizeof(si);
            // Start the child process.
            if (!CreateProcess(
              NULL, // No module name (use command line).
              commandline,      // Command line.
              NULL,             // Process handle not inheritable.
              NULL,             // Thread handle not inheritable.
              FALSE,            // Set handle inheritance to FALSE.
              0,                // No creation flags.
              NULL,             // Use parent's environment block.
              currentdir,       // current directory.
              &si,              // Pointer to STARTUPINFO structure.
              &pi))             // Pointer to PROCESS_INFORMATION structure.
            {
              MessageBox(window, "Error in calling POST.EXE",
                "Plain Vanilla Posting 3.0", MB_OK);
            }
            else
            {
              // Wait until child process exits.
              WaitForSingleObject( pi.hProcess, INFINITE );
              // Close process and thread handles.
              CloseHandle( pi.hProcess );
              CloseHandle( pi.hThread );
              const int ABBREVIATION = 35;
              char caption[19+ABBREVIATION+1];
              strcpy(caption, "Error messages for ");
              abbreviate_filespecs(caption+19, specs, ABBREVIATION);
              SetDlgItemText(window, ERRCAPID, caption);
              FILE *f = fopen(tempspecs, "rb");
              if (f == NULL)
                SetDlgItemText(window, ERRCAPID, "Temporary file error");
              else
              {
                const ERROR_SIZE = 4*1024;
                char *errors = new char[ERROR_SIZE+50];
                int c;
                int i = 0;
                bool overflow = false;
                while ((c = fgetc(f)) != EOF)
                {
                  if (i < ERROR_SIZE)
                    errors[i++] = c;
                  else
                  {
                    overflow = true;
                    break;
                  }
                }
                if (overflow)
                {
                  while (i > 0 && errors[i] != '\r')
                    i--;
                  strcpy(errors+i+2, "\r\nAdditional message(s) omitted\r\n");
                }
                else
                  errors[i] = 0;
                SetDlgItemText(window, ERRORID, errors);
                fclose(f);
                delete [] errors;
              }
              remove(tempspecs);
            }
          }
          return 0;
        }
        case LISTID:
          // if (HIWORD(wParam) == LBN_DBLCLK)
          // {
          // }
          if (HIWORD(wParam) == LBN_SELCHANGE)
          {
            int i = SendDlgItemMessage(window, LISTID, LB_GETCURSEL, 0, 0);
            EnableWindow(GetDlgItem(window, POSTID), i >= 0);
            EnableWindow(GetDlgItem(window, REMOVEID), i >= 0);
          }
          return 0;
      }
      break;
    case WM_CLOSE:
      DestroyWindow(window);
      return 0;
    case WM_DESTROY:
      if (configspecs[0] != 0)
      {
        FILE *fp = fopen(configspecs, "w");
        if (fp != NULL)
        {
          fputs(addspecs, fp);
          fputc('\n', fp);
          int n = SendDlgItemMessage(window, LISTID, LB_GETCOUNT, 0, 0);
          int i;
          for (i = 0; i < n; i++)
          {
            SendDlgItemMessage(window, LISTID, LB_GETTEXT, i, (LPARAM) specs);
            fputs(specs, fp);
            fputc('\n', fp);
          }
          fclose(fp);
        }
      }
      PostQuitMessage(0);
      return 0;
  }
  return DefDlgProc(window, message, wParam, lParam);
}

static void get_config_line(char *s)
{
  while (configchar != '\n' && configchar != EOF)
  {
    *s++ = configchar;
    configchar = getc(config);
  }
  *s = 0;
  if (configchar == '\n')
    configchar = getc(config);
}

#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{

  {
    strcpy(configspecs, _argv[0]);
    char *s = configspecs;
    while (*s != 0 && strcmpi(s, ".EXE") != 0)
      s++;
    if (*s != 0)
      strcpy(s, ".CFG");
    else
      configspecs[0] = 0;
  }

#if 0
  while (*lpszCmdLine == ' ' || *lpszCmdLine == '\t')
    lpszCmdLine++;
  if (*lpszCmdLine != 0)
  {
    int i = 0;
    while (*lpszCmdLine != 0 && i < sizeof(specs)-1)
      specs[i++] = *lpszCmdLine++;
    while (i > 0 && specs[i-1] == ' ' || specs[i-1] == '\t')
      i--;
    specs[i] = 0;
    if (i > 0)
    {
      post(specs);
      return 0;
    }
  }
#endif

  if (!hPrevInstance)
  {
    WNDCLASS wndclass;
    wndclass.style = 0;
    wndclass.lpfnWndProc = WndProc;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = DLGWINDOWEXTRA;
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon(hInstance, "PVPOSTICON");
    wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = NULL;
    wndclass.lpszMenuName = NULL;
    wndclass.lpszClassName = "GUIPOSTCLASS";
    RegisterClass (&wndclass);
  }

  HWND window = (HWND) CreateDialog(hInstance, "GUIPOSTDIALOG", 0, NULL);

  if (configspecs[0] != 0)
  {
    config = fopen(configspecs, "r");
    if (config != NULL)
    {
      configchar = getc(config);
      get_config_line(addspecs);
      while (configchar != EOF)
      {
        get_config_line(specs);
        SendDlgItemMessage(window, LISTID, LB_ADDSTRING, 0, (LPARAM) specs);
      }
      fclose(config);
    }
  }

  ShowWindow(window, nCmdShow == SW_SHOWMAXIMIZED ? SW_SHOW : nCmdShow);
  UpdateWindow(window);

  MSG message;

  while (GetMessage(&message, NULL, 0, 0))
  {
    if (!IsDialogMessage (window, &message))
        DispatchMessage (&message);
  }

  return message.wParam;
}


